<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Sports  Widget</title>
	
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css">

</head>
<body>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
<!-- Latest compiled and minified JavaScript -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js"></script>
<script src="jquery.searchable.js"></script>


<?php

require_once("creds.php"); //gets credentials to access TV Media's APIs

// Creating the pieces that will make up the URL for the API call

  // Base URL for all API calls
  $apiURL = 'http://api.tvmedia.ca/tv/v4/'; 

  // Add 2 weeks to current date to make sure you're getting all available listings. 
  // The amount of future programming you can retreive depends on your developer.tvmedia.ca plan - https://developer.tvmedia.ca/pricing-plans
  $endDate = date("Y-m-d", strtotime("+15 days")); 
  
  // Required Lineup ID to make call. Note: Sample Plan is restricted to a few generic lineups
  $lineupID = '36617'; 
  
  // This is the operation method that access listings
  // https://developer.tvmedia.ca/active-docs
  $apiMethod = 'lineups/'. $lineupID .'/listings?';
  
  // Adds the league ID so we only see MLB games. Feel free to use another league.
  // https://developer.tvmedia.ca/docs#leagues
  $leagueFilter = '&league=MLB'; 


  // Build URL to make API call URL
  $url = $apiURL . $apiMethod . $leagueFilter . $secretKey . '&end=' .$endDate;

  // To be commented out before implementation. Only here so we can see that the correct URL is being built
  echo $url; 

  // PHP call to get the JSON as a string
  $file_contents = file_get_contents($url); 

  // Decodes the JSON string and converts into an array
  $listings = json_decode($file_contents, true); 

  // print_r($listings); // Can be uncommented to see all values returned

  
  // Let's create our sports widget!

  // We're using Bootstrap for the CSS and HTML for our sports listings. www/getbootstrap.com
  // and we are using the jquery-searchable plugin found here https://github.com/stidges/jquery-searchable
  // you will also need jquery.

?>




<div class="container">
	<div class="row">
    <div class="row">
      <div class="col-lg-12">
        <div class="page-header">
          <h1>MLB Searchable Sports TV Schedule</h1>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-lg-4">
        <input type="search" id="search" value="" class="form-control" placeholder="Search for your teams or venue">
      </div>
    </div>
    <div class="row">
      <div class="col-lg-12">
        <table class="table" id="table">
          <thead>
            <tr>
              <th>Date &amp; Time</th>
              <th>Team</th>
              <th>Location</th>
              <th>Channel</th>
              <th></th>
            </tr>
          </thead>
					<tbody>
					<?php foreach ($listings as $listing) { ?>
						<tr>
							<td><?php echo $listing['listDateTime'];?></td>
              <td><?php if ($listing['event']) {
                  echo '<strong>'.$listing['event'].'</strong> <br>';
              }?>
              <?php if ($listing['team1'] != '') {?>
                <?php echo $listing['team1'];?> vs.<?php echo $listing['team2'];?>
              <?php } else echo "Teams To Be Announced"; ?>
              </td>
              <td><?php echo $listing['location'];?></td>
              <td><?php echo $listing['name']; ?> </td>
              <td>
              <?php if ($listing['live'] == 'true') {?>
                  <span class="label label-primary">Live</span>
              <?php } ?>
              </td>
            </tr>
					<?php } ?>	    
					</tbody>
    		</table>
		</div>
	</div>
</div>



<script>

$(function () {
    $( '#table' ).searchable({
        striped: true,
        oddRow: { 'background-color': '#f5f5f5' },
        evenRow: { 'background-color': '#fff' },
        searchType: 'default'
    });
    
    $( '#searchable-container' ).searchable({
        searchField: '#container-search',
        selector: '.row',
        childSelector: '.col-xs-4',
        show: function( elem ) {
            elem.slideDown(100);
        },
        hide: function( elem ) {
            elem.slideUp( 100 );
        }
    })
});

</script>

</body>
</html>